package centrocommerciale.utils;

import java.util.List;
import java.util.StringTokenizer;


/**
 * Riceve le Liste e le formatta secondo i campi: id_attività tipo numero_locali
 * mq_tot costi_propri per restituire ciascuno separatamente.
 * Ovviamente adattabile a qualsiasi formattazione avrà il/i file.
 * 
 * @param attività l'elenco delle attività del CommerceCentre
 * @param incassi Singoli incassi delle attività (devono corrispondere in numero al # di attività)
 * @author koelio
 * @see Main per come sono ottenute le liste
 * 
 */
public class Formatter implements IFormatter {
	List<String> attività;
	List<String> incassi;
	StringTokenizer tokenizer;

	int index;
	String[] id;
	String[] type;
	String[] localNumber;
	String[] mq;
	String[] costs;
	String[] income;

	public Formatter(List<String> attività, List<String> incassi) {
		this.attività = attività;
		this.incassi = incassi;

		this.id = new String[attività.size()];
		this.type = new String[attività.size()];
		this.localNumber = new String[attività.size()];
		this.mq= new String[attività.size()];
		this.costs = new String[attività.size()];
		this.income = new String[incassi.size()];
		
		
		for (int i = 0; i < attività.size(); i++) {
			
			StringTokenizer tokenizer = new StringTokenizer(
					attività.get(i));

			this.id[i] = tokenizer.nextToken();
			this.type[i] = tokenizer.nextToken();
			this.localNumber[i] = tokenizer.nextToken();
			this.mq[i] = tokenizer.nextToken();
			this.costs[i] = tokenizer.nextToken();

			StringTokenizer tokenizer2 = new StringTokenizer(
					incassi.get(i));
			this.income[i] = tokenizer2.nextToken();
			
		}
		
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public String getId() {

		return id[index];
	}
	
	public String getType() {

		return type[index];
	}

	public int getLocalNumber() {

		return Integer.parseInt(localNumber[index]);
	}

	public int getMqTot() {

		return Integer.parseInt(mq[index]);
	}

	public int getOwnFixedCosts() {

		return Integer.parseInt(costs[index]);
	}

	public int getIncome() {

		return Integer.parseInt(income[index]);
	}

	public int getSize() {

		return attività.size();
	}
}
